#ifndef TIMER_H
#define TIMER_H

// Copyright ***********************************************************
//
// 	The information in this file is copyright 1991 by David Orme.
//
//		Anyone may use this information for any purpose as long as he takes
//		responsability for any and all libility incurred from its use
//		or misuse and acknowledges its use in the user documentation.  This
//		information is provided AS IS with no warrenty of any kind, either
//		expressed or implied.
//
// End *****************************************************************


// Contents **********************************************************
//
//		Timer class definition
//
// Description
//
//		The timer class implements a simple DOS timer ISR and allows
//		timing tasks to be accomplished while other processing
//		occurs.  Note that all instances of this class reference the
//		_same_ timer ISR in memory.
//
// End ***************************************************************


// Interface dependencies ---------------------------------------------

// -- NONE --


// Implementation dependencies ----------------------------------------

// -- NONE --



// Global variables ---------------------------------------------------

const int TIMER = 0x1c;		// DOS timer int vector


class Timer {
private:
	static volatile unsigned long ticker;
	static void interrupt (far *oldtimer)(...);
	static void interrupt far NewTimer(...);

public:
	Timer();
	~Timer();
	void Set(float seconds=0)	{ ticker=seconds*182/10+1; }
	int TimeOut()					{ return !ticker; }
};

// Description ---------------------------------------------------------
//
//		Defines the Timer class;  The constructor sets up NewTimer
//		as an ISR on the DOS timer interrupt and sets the ticker
//		to 0.  The timer may be set to time any task in the background
//		while other processing occurs and requires a minimal amount
//		of CPU time.
//
// SetTimer(unsigned seconds=0)
//
//		Set the timer to return to 0 in as many secs as you like.
//
// int TimeOut()
//
//		Returns true (!0) when the time set by SetTimer has elapsed.
//
// End -----------------------------------------------------------------




#endif

