// Copyright ***********************************************************
//
// 	The information in this file is copyright 1991 by David Orme.
//
//		Anyone may use this information for any purpose as long as he takes
//		responsability for any and all libility incurred from its use
//		or misuse and acknowledges its use in the user documentation.  This
//		information is provided AS IS with no warrenty of any kind, either
//		expressed or implied.
//
// End *****************************************************************


// Contents ************************************************************
//
//		Timer::Timer()
//		Timer::~Timer()
//		Timer::NewTimer()
//
// Description
//
//		The Timer class implements a hardware-based background timer.
//		Note that all instances of this class reference the _same_ timer
//		ISR.
//
// End *****************************************************************


// Interface Dependencies ----------------------------------------------

#ifndef __TIMER_H
#include "timer.h"
#endif


// Implementation Dependencies -----------------------------------------

#ifndef __DOS_H
#include <dos.h>
#define __DOS_H
#endif


// Global Variables ----------------------------------------------------

volatile unsigned long Timer::ticker=0;
void interrupt (far * Timer::oldtimer)(...)=0;


// Constructor //

Timer::Timer()

// Summary -------------------------------------------------------------
//
//		Initialize the new timer interrupt handler
//
// End -----------------------------------------------------------------

{
	ticker=0;
	oldtimer = getvect(TIMER);
	setvect(TIMER, Timer::NewTimer);
}



// Destructor //

Timer::~Timer()

// Summary --------------------------------------------------------------
//
//		Restore the old timer interrupt in the chain
//
// End ------------------------------------------------------------------

{
	setvect(TIMER, oldtimer);
}



// ISR //

void interrupt far Timer::NewTimer(...)

// Summary --------------------------------------------------------------
//
//		After chaining to the old interrupt handler, decrement our
//		counter if it is greater than 0.
//
// End ------------------------------------------------------------------

{
    (*oldtimer)();
    if (ticker)
        --ticker;
}

